/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.tools;

import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.excessiveplus.common.bind.Bind;
import net.excessiveplus.common.image.TgaImage;
import net.excessiveplus.common.image.TgaInputStream;

public class Utils {
    public static final int BUFFER_SIZE = 2048;
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static final String[] COMMON_CHARSETS = new String[]{"Cp1252", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO8859_15", "UTF-16", "UTF-16BE", "UTF-16LE"};
    public static final String[] BASIC_CHARSETS = new String[]{"Cp1252", "UTF-8", "ISO-8859-1", "US-ASCII", "UTF-16", "ISO8859_15", "UTF-16BE", "UTF-16LE", "Cp858", "Cp437", "Cp775", "Cp850", "Cp852", "Cp855", "Cp857", "Cp862", "Cp866", "ISO8859_2", "ISO8859_4", "ISO8859_5", "ISO8859_7", "ISO8859_9", "ISO8859_13", "KOI8_R", "KOI8_U", "UTF_32", "UTF_32BE", "UTF_32LE", "UTF_32BE_BOM", "UTF_32LE_BOM", "Cp1250", "Cp1251", "Cp1253", "Cp1254", "Cp1257", "Cp737", "Cp874", "UnicodeBig", "UnicodeLittle"};
    private static final String BIND_REGEX = "bind\\p{Blank}+[0-9a-zA-Z\\_\\'\\-\\/\\=\\[\\\\\\]\\,\\.\\*]+\\p{Blank}+\\\"[\u0000-\u00ff]*\\\"";
    private static final String CVAR_REGEX_START = "(set[aus]?\\p{Blank}+)?";
    private static final String CVAR_REGEX_END = "\\p{Blank}+\\\"[\u0000-\u00ff]*\\\"";

    public static void center(Container container) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        Dimension size = container.getSize();
        int cHeight = size.height;
        int cWidth = size.width;
        container.setLocation(screenWidth / 2 - cWidth / 2, screenHeight / 2 - cHeight / 2);
    }

    public static byte[] readZipEntry(ZipFile zipFile, String zipEntryName) {
        if (zipFile == null || zipEntryName == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
        return Utils.readZipEntry(zipFile, zipEntry);
    }

    public static byte[] readZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
        return Utils.readZipEntry(zipFile, zipEntry, 2048);
    }

    public static byte[] readZipEntry(ZipFile zipFile, ZipEntry zipEntry, int bufferSize) {
        if (zipFile == null || zipEntry == null) {
            return null;
        }
        if (bufferSize < 512) {
            bufferSize = 512;
        }
        try {
            InputStream is = zipFile.getInputStream(zipEntry);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            while ((count = is.read(buffer, 0, bufferSize)) != -1) {
                baos.write(buffer, 0, count);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadRessourceTgaImage(String imagePath) {
        TgaImage image = null;
        TgaInputStream tgaIS = new TgaInputStream(Object.class.getResourceAsStream(imagePath));
        try {
            image = tgaIS.getTgaImage();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static BufferedImage loadRessourceImage(String imagePath) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(Object.class.getResourceAsStream(imagePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static byte[] loadRessourceBytes(String filePath) {
        byte[] bytes = null;
        try {
            InputStream is = Object.class.getResourceAsStream(filePath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            int count = 0;
            while ((count = is.read(buffer, 0, 2048)) != -1) {
                baos.write(buffer, 0, count);
            }
            baos.close();
            is.close();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static void visitURI(String uri) {
        try {
            Desktop.getDesktop().browse(new URI(uri));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static Bind readBind(String line) {
        String tmp = line.trim();
        if (tmp.matches(BIND_REGEX)) {
            return Bind.validate(tmp);
        }
        return null;
    }

    public static String readCvar(String cvar, String line) {
        String tmp = line.trim();
        if (tmp.matches(CVAR_REGEX_START + cvar + CVAR_REGEX_END)) {
            return tmp.substring(tmp.indexOf("\"") + 1, tmp.length() - 1);
        }
        return null;
    }

    public static String checkFileEncoding(File file) throws IOException {
        return Utils.checkFileEncoding(file, COMMON_CHARSETS);
    }

    public static String checkFileEncoding(File file, String[] charsets) throws IOException {
        if (file == null || charsets == null || charsets.length == 0) {
            return null;
        }
        String[] stringArray = charsets;
        int n = charsets.length;
        int n2 = 0;
        while (n2 < n) {
            String charset = stringArray[n2];
            if (Utils.checkFileEncoding(file, charset)) {
                return charset;
            }
            ++n2;
        }
        return null;
    }

    public static boolean checkFileEncoding(File file, String charset) throws IOException {
        if (file == null || charset == null) {
            return false;
        }
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        int c = 0;
        boolean valid = true;
        while (c != -1) {
            c = isr.read();
            if ((c & 0xFFFF) != 65533) continue;
            valid = false;
            break;
        }
        isr.close();
        return valid;
    }

    public static String readFileEncoding(File file, String charset) throws IOException {
        if (file == null || charset == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        int c = 0;
        StringBuffer sb = new StringBuffer();
        while ((c = isr.read()) != -1) {
            sb.append((char)c);
        }
        isr.close();
        return sb.toString();
    }
}

