/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.tools;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import net.excessiveplus.common.image.TgaImage;
import net.excessiveplus.common.tools.Hexa;
import net.excessiveplus.common.tools.Utils;

public class Qname {
    public static final Color[] STD_COLORS = new Color[]{new Color(0.05f, 0.05f, 0.05f), new Color(0.91f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.16f), new Color(0.96f, 0.85f, 0.0f), new Color(0.18f, 0.38f, 0.78f), new Color(0.09f, 0.71f, 0.65f), new Color(0.96f, 0.03f, 0.95f), new Color(0.9f, 0.9f, 0.9f)};
    public static final String ENTRY_FLAGS = "gfx/flags/";
    public static final String ENTRY_FONTS = "fonts/";
    public static final String ENTRY_SOUND_VOICES = "sound/voices/";

    public static String transformFromNameToXPName(String name) {
        String xpName = "";
        while (name.length() != 0) {
            int ascii;
            if (name.length() >= 2 && Qname.isStdColor(name.substring(0, 2))) {
                xpName = String.valueOf(xpName) + name.substring(0, 2);
                name = name.substring(2);
                continue;
            }
            if (name.length() >= 8 && Qname.isCustomColor(name.substring(0, 8))) {
                xpName = String.valueOf(xpName) + name.substring(0, 8);
                name = name.substring(8);
                continue;
            }
            if (name.length() >= 3 && Qname.isAlphaEffect(name.substring(0, 3))) {
                xpName = String.valueOf(xpName) + name.substring(0, 3);
                name = name.substring(3);
                continue;
            }
            if (name.length() >= 2 && Qname.isQnameEffect(name.substring(0, 2))) {
                xpName = String.valueOf(xpName) + name.substring(0, 2);
                name = name.substring(2);
                continue;
            }
            if (name.length() >= 2 && Qname.isOtherColor(name.substring(0, 2))) {
                xpName = String.valueOf(xpName) + name.substring(0, 2);
                name = name.substring(2);
                continue;
            }
            if (name.length() >= 3 && Qname.isQnameCharCode(name.substring(0, 3))) {
                ascii = name.codePointAt(1);
                ascii = (ascii + 127) % 256;
                xpName = String.valueOf(xpName) + "#" + Hexa.toNHexa(ascii, 2);
                name = name.substring(3);
                continue;
            }
            if (name.length() >= 1 && Qname.isWritableChar(name.substring(0, 1))) {
                xpName = String.valueOf(xpName) + name.substring(0, 1);
                name = name.substring(1);
                continue;
            }
            ascii = name.codePointAt(0);
            xpName = String.valueOf(xpName) + "#" + Hexa.toNHexa(ascii, 2);
            name = name.substring(1);
        }
        return xpName;
    }

    public static boolean isStdColor(String code) {
        return code.matches("\\^[0-7]");
    }

    public static boolean isCustomColor(String code) {
        return code.matches("\\^x\\p{XDigit}{6}");
    }

    public static boolean isAlphaEffect(String code) {
        return code.matches("\\^a[1-9]");
    }

    public static boolean isQnameEffect(String code) {
        return code.matches("\\^[bBfFrRs]");
    }

    public static boolean isXPQnameEffect(String code) {
        return code.matches("\\^[bBfFrRols]");
    }

    public static boolean isOtherColor(String code) {
        return code.matches("\\^[\u0000-\u00ff]");
    }

    public static boolean isQnameCharCode(String code) {
        return code.matches("\\+[\u0000-\u00ff]*\\#");
    }

    public static boolean isXPQnameCharCode(String code) {
        return code.matches("\\#\\p{XDigit}{2}");
    }

    public static boolean isWritableChar(String code) {
        int ascii = code.codePointAt(0);
        return ascii >= 32 && ascii <= 126;
    }

    public static String toCustomColor(Color color) {
        String code = "^x";
        code = String.valueOf(code) + Hexa.toNHexa(color.getRed(), 2);
        code = String.valueOf(code) + Hexa.toNHexa(color.getGreen(), 2);
        code = String.valueOf(code) + Hexa.toNHexa(color.getBlue(), 2);
        return code;
    }

    public static Color fromCustomColor(String code) {
        int red = Hexa.fromHexa(code.substring(0, 2));
        int green = Hexa.fromHexa(code.substring(2, 4));
        int blue = Hexa.fromHexa(code.substring(4, 6));
        return new Color(red, green, blue);
    }

    public static void readFlags(ZipFile zipFile, Map<String, ImageIcon> countryImageMap) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry flagEntry = zipEntries.nextElement();
            String entryName = flagEntry.getName();
            if (!entryName.startsWith(ENTRY_FLAGS) || !entryName.endsWith(".tga")) continue;
            String key = entryName.substring(ENTRY_FLAGS.length(), entryName.length() - 4);
            key = key.toUpperCase();
            byte[] bytes = Utils.readZipEntry(zipFile, flagEntry);
            if (bytes == null || countryImageMap.containsKey(key)) continue;
            countryImageMap.put(key, new ImageIcon(new TgaImage(bytes)));
        }
    }

    public static void readSoundBinds(ZipFile zipFile, Map<String, byte[]> soundBinds) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry flagEntry = zipEntries.nextElement();
            String entryName = flagEntry.getName();
            if (!entryName.startsWith(ENTRY_SOUND_VOICES) || !entryName.endsWith(".wav")) continue;
            String key = entryName.substring(ENTRY_SOUND_VOICES.length());
            byte[] bytes = Utils.readZipEntry(zipFile, flagEntry);
            if (bytes == null || soundBinds.containsKey(key)) continue;
            soundBinds.put(key, bytes);
        }
    }

    public static BufferedImage[][] readFonts(ZipFile zipFile) {
        BufferedImage[][] xpFont = new BufferedImage[2][2];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                byte[] bytes;
                String entryName = "fonts/xp_";
                if (j == 1) {
                    entryName = String.valueOf(entryName) + "l_";
                }
                if ((bytes = Utils.readZipEntry(zipFile, entryName = String.valueOf(entryName) + 16 * (i + 1) + ".tga")) == null) {
                    return null;
                }
                xpFont[i][j] = new TgaImage(bytes);
                ++j;
            }
            ++i;
        }
        return xpFont;
    }
}

