/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.tools;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.util.List;
import java.util.Vector;
import net.excessiveplus.common.image.filter.BackgroundFilter;
import net.excessiveplus.common.image.filter.CommonFilter;
import net.excessiveplus.common.image.filter.GlowFilter;
import net.excessiveplus.common.tools.AnimatedGifEncoder;
import net.excessiveplus.common.tools.Hexa;
import net.excessiveplus.common.tools.Qname;
import net.excessiveplus.common.tools.Utils;

public class AnimatedGifGenerator {
    public static final int CHAR_NUM = 16;
    public static final int CHAR_WIDTH = 16;
    public static final int CHAR_HEIGHT = 16;
    public static final int CHAR_DRAWN_WIDTH = 14;
    public static final int CHAR_DRAWN_HEIGHT = 20;
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0);
    public static final String EMPTY_CODE = "^l^b^3#C5#CD#D0#D4#D9 #C3#CF#C4#C5";
    public static final String INVALID_CODE = "^l^b^1#C9#CE#D6#C1#CC#C9#C4 #C3#CF#C4#C5";
    public static final String REFRESHING_CODE = "^l^2#D2#C5#C6#D2#C5#D3#C8#C9#CE#C7...";
    private List<List<Image>> lstLstImages;
    private Color color1;
    private Color color2;
    private boolean color1flag;
    private int alpha;
    private boolean blink1;
    private boolean blink2;
    private boolean fade1;
    private boolean fade2;
    private boolean replace1;
    private boolean replace2;
    private boolean glow;
    private int thin;
    private Container container;
    private BufferedImage[][] xpFont;
    private int previewMode;
    private Color bgColor;
    private int quality;
    private int[][][][] leftXPos;
    private int[][][][] rightXPos;
    private BufferedImage image;
    public static byte[] emptyCodeBytes;
    public static byte[] invalidCodeBytes;
    public static byte[] refreshingCodeBytes;
    private byte[] errorBytes;

    public AnimatedGifGenerator(Container container, BufferedImage[][] xpFont, int previewMode, Color bgColor) {
        this.container = container;
        this.xpFont = xpFont;
        this.previewMode = previewMode;
        this.bgColor = bgColor;
        this.setQuality(10);
        this.leftXPos = new int[2][2][16][16];
        this.rightXPos = new int[2][2][16][16];
        int k = 0;
        while (k < 2) {
            int coef = k + 1;
            int xSize = coef * 16;
            int ySize = coef * 16;
            int l = 0;
            while (l < 2) {
                BufferedImage xpFontImage = xpFont[k][l];
                int i = 0;
                while (i < 16) {
                    int j = 0;
                    while (j < 16) {
                        BufferedImage image = xpFontImage.getSubimage(i * xSize, j * ySize, xSize, ySize);
                        this.leftXPos[k][l][i][j] = this.getLeftXPos(image, coef);
                        this.rightXPos[k][l][i][j] = this.getRightXPos(image, coef);
                        ++j;
                    }
                    ++i;
                }
                ++l;
            }
            ++k;
        }
        if (emptyCodeBytes == null) {
            emptyCodeBytes = this.generateGif(EMPTY_CODE);
        }
        if (invalidCodeBytes == null) {
            invalidCodeBytes = this.generateGif(INVALID_CODE);
        }
        if (refreshingCodeBytes == null) {
            refreshingCodeBytes = this.generateGif(REFRESHING_CODE);
        }
    }

    private int getLeftXPos(BufferedImage image, int coef) {
        int maxWidth = coef * 16 - 1;
        int maxHeight = coef * 16 - 1;
        int x = 0;
        while (x <= maxWidth) {
            int y = 0;
            while (y <= maxHeight) {
                if (image.getRGB(x, y) >> 24 != 0) {
                    return x;
                }
                ++y;
            }
            ++x;
        }
        return coef * 2;
    }

    private int getRightXPos(BufferedImage image, int coef) {
        int maxWidth = coef * 16 - 1;
        int maxHeight = coef * 16 - 1;
        int x = maxWidth;
        while (x >= 1) {
            int y = maxHeight;
            while (y >= 1) {
                if (image.getRGB(x, y) >> 24 != 0) {
                    return x;
                }
                --y;
            }
            --x;
        }
        return maxWidth - coef * 2;
    }

    public boolean saveGif(String code, File file) {
        if (!this.parseCode(code)) {
            return false;
        }
        AnimatedGifEncoder animatedGifEncoder = this.prepareAnimatedGif(code);
        if (animatedGifEncoder == null) {
            return false;
        }
        return animatedGifEncoder.save(file);
    }

    public byte[] generateGif(String code) {
        if (!this.parseCode(code)) {
            return this.errorBytes;
        }
        AnimatedGifEncoder animatedGifEncoder = this.prepareAnimatedGif(code);
        if (animatedGifEncoder == null) {
            return null;
        }
        return animatedGifEncoder.finish();
    }

    private AnimatedGifEncoder prepareAnimatedGif(String code) {
        List<Image> lstImages;
        int coef = this.previewMode + 1;
        int maxWidth = 0;
        int maxHeight = coef * 20;
        int offsetWidth = coef * 4;
        int glowWidth = coef * 2;
        int bgRGB = this.bgColor.getRGB();
        int[] widths = new int[this.lstLstImages.size()];
        int i = 0;
        while (i < this.lstLstImages.size()) {
            lstImages = this.lstLstImages.get(i);
            widths[i] = 0;
            int j = 0;
            while (j < lstImages.size()) {
                int n = i;
                widths[n] = widths[n] + (lstImages.get(j).getWidth(null) - glowWidth);
                ++j;
            }
            maxWidth = Math.max(widths[i], maxWidth);
            ++i;
        }
        if (maxWidth == 0) {
            return null;
        }
        maxWidth += 2 * offsetWidth;
        AnimatedGifEncoder animetedGifEncoder = new AnimatedGifEncoder();
        animetedGifEncoder.start();
        animetedGifEncoder.setDelay(100);
        animetedGifEncoder.setRepeat(0);
        animetedGifEncoder.setDispose(2);
        animetedGifEncoder.setSize(maxWidth, maxHeight);
        animetedGifEncoder.setQuality(this.quality);
        int i2 = 0;
        while (i2 < this.lstLstImages.size()) {
            lstImages = this.lstLstImages.get(i2);
            this.image = new BufferedImage(maxWidth, maxHeight, 2);
            int y = 0;
            while (y < this.image.getHeight()) {
                int x = 0;
                while (x < this.image.getWidth()) {
                    this.image.setRGB(x, y, bgRGB);
                    ++x;
                }
                ++y;
            }
            Graphics2D graphic = this.image.createGraphics();
            int xPos = offsetWidth - coef;
            int j = 0;
            while (j < lstImages.size()) {
                Image subImage = lstImages.get(j);
                graphic.drawImage(subImage, xPos, 0, null);
                xPos += subImage.getWidth(null) - glowWidth;
                ++j;
            }
            animetedGifEncoder.addFrame(this.image);
            ++i2;
        }
        return animetedGifEncoder;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseCode(String code) {
        this.lstLstImages = new Vector<List<Image>>();
        i = 0;
        while (i < 20) {
            this.lstLstImages.add(new Vector<E>());
            ++i;
        }
        this.initGenerator();
        if (code.length() != 0) ** GOTO lbl97
        this.errorBytes = AnimatedGifGenerator.emptyCodeBytes;
        return false;
lbl-1000:
        // 1 sources

        {
            if (code.length() >= 2 && Qname.isStdColor(code.substring(0, 2))) {
                color = Qname.STD_COLORS[Integer.parseInt(code.substring(1, 2))];
                this.setCurrentColor(color);
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 8 && Qname.isCustomColor(code.substring(0, 8))) {
                color = Qname.fromCustomColor(code.substring(2, 8));
                this.setCurrentColor(color);
                code = code.substring(8);
                continue;
            }
            this.color1flag = false;
            if (code.length() >= 3 && Qname.isAlphaEffect(code.substring(0, 3))) {
                this.alpha = Integer.parseInt(code.substring(2, 3));
                code = code.substring(3);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^b")) {
                this.blink1 = true;
                this.blink2 = false;
                this.replace1 = false;
                this.replace2 = false;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^B")) {
                this.blink1 = false;
                this.blink2 = true;
                this.replace1 = false;
                this.replace2 = false;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^f")) {
                this.fade1 = true;
                this.fade2 = false;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^F")) {
                this.fade1 = false;
                this.fade2 = true;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^r")) {
                this.replace1 = true;
                this.replace2 = false;
                this.blink1 = false;
                this.blink2 = false;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^R")) {
                this.replace1 = false;
                this.replace2 = true;
                this.blink1 = false;
                this.blink2 = false;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^o")) {
                this.glow = true;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^l")) {
                this.thin = 1;
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && code.substring(0, 2).equals("^s")) {
                this.initGenerator();
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 2 && Qname.isOtherColor(code.substring(0, 2))) {
                color = Qname.STD_COLORS[code.codePointAt(1) - 48 & 7];
                this.setCurrentColor(color);
                code = code.substring(2);
                continue;
            }
            if (code.length() >= 3 && Qname.isXPQnameCharCode(code.substring(0, 3))) {
                x = Hexa.fromHexa(code.substring(2, 3));
                y = Hexa.fromHexa(code.substring(1, 2));
                this.addImage(x, y);
                code = code.substring(3);
                continue;
            }
            if (code.length() >= 1 && Qname.isWritableChar(code.substring(0, 1))) {
                intCode = code.codePointAt(0);
                x = intCode % 16;
                y = intCode / 16;
                this.addImage(x, y);
                code = code.substring(1);
                continue;
            }
            this.errorBytes = AnimatedGifGenerator.invalidCodeBytes;
            return false;
lbl97:
            // 16 sources

            ** while (code.length() != 0)
        }
lbl98:
        // 1 sources

        return true;
    }

    private void initGenerator() {
        this.color1 = Qname.STD_COLORS[7];
        this.color2 = Qname.STD_COLORS[0];
        this.color1flag = false;
        this.alpha = 10;
        this.blink1 = false;
        this.blink2 = false;
        this.fade1 = false;
        this.fade2 = false;
        this.replace1 = false;
        this.replace2 = false;
        this.glow = false;
        this.thin = 0;
    }

    private void addImage(int x, int y) {
        Image imageDest = null;
        int curAlpha = 0;
        int coef = this.previewMode + 1;
        int xSize = this.rightXPos[this.previewMode][this.thin][x][y] - this.leftXPos[this.previewMode][this.thin][x][y] + 1;
        int ySize = coef * 16;
        int xPos = x * coef * 16 + this.leftXPos[this.previewMode][this.thin][x][y];
        int yPos = y * ySize;
        BufferedImage imageSource = this.xpFont[this.previewMode][this.thin].getSubimage(xPos, yPos, xSize, ySize);
        int i = 0;
        while (i < this.lstLstImages.size()) {
            List<Image> lstImages = this.lstLstImages.get(i);
            boolean keepImage = false;
            if (!(!this.replace1 ? this.replace2 && !this.isToReplace(i, true) : !this.isToReplace(i, false))) {
                if (this.blink1) {
                    if (curAlpha == this.blinkAlpha(i, false)) {
                        keepImage = true;
                    } else {
                        curAlpha = this.blinkAlpha(i, false);
                    }
                } else if (this.blink2) {
                    if (curAlpha == this.blinkAlpha(i, true)) {
                        keepImage = true;
                    } else {
                        curAlpha = this.blinkAlpha(i, true);
                    }
                } else if (this.fade1) {
                    curAlpha = this.fadeAlpha(i, false);
                } else if (this.fade2) {
                    curAlpha = this.fadeAlpha(i, true);
                } else {
                    curAlpha = 255 * this.alpha / 10;
                    keepImage = true;
                }
                if (!keepImage || imageDest == null) {
                    Color c1 = new Color(this.color1.getRGB());
                    Color c2 = new Color(this.color2.getRGB());
                    CommonFilter filter = this.glow ? new GlowFilter(c1, c2, this.bgColor, coef * 2, curAlpha) : new BackgroundFilter(c1, c2, this.bgColor, coef * 2, curAlpha);
                    FilteredImageSource filteredImageSource = new FilteredImageSource(((Image)imageSource).getSource(), filter);
                    imageDest = this.container.createImage(filteredImageSource);
                }
                lstImages.add(imageDest);
            }
            ++i;
        }
    }

    private void setCurrentColor(Color color) {
        if (!this.color1flag) {
            this.color1 = color;
            this.color1flag = true;
        } else {
            this.color2 = color;
            this.color1flag = false;
        }
    }

    private boolean isToReplace(int i, boolean inOut) {
        if (inOut && i != 0 && i < 11) {
            return true;
        }
        return !inOut && (i == 0 || i >= 11);
    }

    private int blinkAlpha(int i, boolean inOut) {
        int j = inOut ? 255 : 0;
        int curAlpha = i != 0 && i < 11 ? 255 - j : j;
        return curAlpha;
    }

    private int fadeAlpha(int i, boolean inOut) {
        int j = i;
        j = inOut ? 10 - i : i;
        int curAlpha = i < 11 ? 255 * j / 10 : 255 * ((20 - j) % 10) / 10;
        return curAlpha;
    }

    public void printGenerationVars() {
        StringBuffer str = new StringBuffer();
        str.append("color1      = " + this.color1 + Utils.LINE_SEP);
        str.append("color2      = " + this.color2 + Utils.LINE_SEP);
        str.append("color1flag  = " + this.color1flag + Utils.LINE_SEP);
        str.append("alpha       = " + this.alpha + Utils.LINE_SEP);
        str.append("blink1      = " + this.blink1 + Utils.LINE_SEP);
        str.append("blink2      = " + this.blink2 + Utils.LINE_SEP);
        str.append("fade1       = " + this.fade1 + Utils.LINE_SEP);
        str.append("fade2       = " + this.fade2 + Utils.LINE_SEP);
        str.append("replace1    = " + this.replace1 + Utils.LINE_SEP);
        str.append("replace2    = " + this.replace2 + Utils.LINE_SEP);
        str.append("glow        = " + this.glow + Utils.LINE_SEP);
        str.append("thin        = " + this.thin + Utils.LINE_SEP);
        System.out.println(str);
    }

    public int getPreviewMode() {
        return this.previewMode;
    }

    public void setPreviewMode(int previewMode) {
        this.previewMode = previewMode;
    }

    public int getThin() {
        return this.thin;
    }

    public void setThin(int thin) {
        this.thin = thin;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }
}

