/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.sound;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveBytesReader {
    private final int EXTERNAL_BUFFER_SIZE = 2048;
    private byte[] soundData;
    private Position curPosition;
    private SourceDataLine auline;
    private Thread thread;
    private Runnable action;
    private boolean paused;

    public WaveBytesReader(byte[] soundData, Runnable action) {
        this.soundData = soundData;
        this.action = action;
        this.curPosition = Position.NORMAL;
    }

    public WaveBytesReader(byte[] soundData, Runnable action, Position p) {
        this.soundData = soundData;
        this.action = action;
        this.curPosition = p;
    }

    public void startReading() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.paused = false;
            this.thread = new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    if (WaveBytesReader.this.soundData == null) {
                        System.err.println("Wave data null !");
                        return;
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(WaveBytesReader.this.soundData);
                    AudioInputStream audioInputStream = null;
                    try {
                        audioInputStream = AudioSystem.getAudioInputStream(bais);
                    }
                    catch (UnsupportedAudioFileException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    AudioFormat format = audioInputStream.getFormat();
                    WaveBytesReader.this.auline = null;
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    try {
                        WaveBytesReader.this.auline = (SourceDataLine)AudioSystem.getLine(info);
                        WaveBytesReader.this.auline.open(format);
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    if (WaveBytesReader.this.auline.isControlSupported(FloatControl.Type.PAN)) {
                        FloatControl pan = (FloatControl)WaveBytesReader.this.auline.getControl(FloatControl.Type.PAN);
                        if (WaveBytesReader.this.curPosition == Position.RIGHT) {
                            pan.setValue(1.0f);
                        } else if (WaveBytesReader.this.curPosition == Position.LEFT) {
                            pan.setValue(-1.0f);
                        }
                    }
                    WaveBytesReader.this.auline.start();
                    int nBytesRead = 0;
                    byte[] abData = new byte[2048];
                    try {
                        try {
                            block13: while (true) {
                                if (nBytesRead == -1) {
                                    return;
                                }
                                while (true) {
                                    if (!WaveBytesReader.this.paused) {
                                        nBytesRead = audioInputStream.read(abData, 0, abData.length);
                                        if (nBytesRead < 0) continue block13;
                                        WaveBytesReader.this.auline.write(abData, 0, nBytesRead);
                                        continue block13;
                                    }
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            WaveBytesReader.this.auline.drain();
                            WaveBytesReader.this.auline.close();
                            if (WaveBytesReader.this.action == null) return;
                            WaveBytesReader.this.action.run();
                            return;
                        }
                    }
                    finally {
                        WaveBytesReader.this.auline.drain();
                        WaveBytesReader.this.auline.close();
                        if (WaveBytesReader.this.action != null) {
                            WaveBytesReader.this.action.run();
                        }
                    }
                }
            });
            this.thread.start();
        }
    }

    public void pauseReading() {
        if (this.thread != null && this.thread.isAlive() && this.auline != null) {
            this.paused = true;
            this.auline.stop();
        }
    }

    public void continueReading() {
        if (this.thread != null && this.thread.isAlive() && this.auline != null) {
            this.auline.start();
            this.paused = false;
        }
    }

    public void stopReading() {
        if (this.thread != null && this.thread.isAlive() && this.auline != null) {
            this.paused = false;
            this.auline.stop();
            this.auline.close();
        }
    }

    static enum Position {
        LEFT,
        RIGHT,
        NORMAL;

    }
}

