/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.image.filter;

import java.awt.Color;
import net.excessiveplus.common.image.filter.CommonFilter;

public class GlowFilter
extends CommonFilter {
    public GlowFilter(Color color1, Color color2, Color bgColor, int radius) {
        super(color1, color2, bgColor, radius, 255);
    }

    public GlowFilter(Color color1, Color color2, Color bgColor, int radius, int alpha) {
        super(color1, color2, bgColor, radius, alpha);
    }

    @Override
    public void imageComplete(int status) {
        int xc;
        int max = 2 * this.radius;
        int yc = 0;
        while (yc < this.height) {
            xc = 0;
            while (xc < this.width) {
                if (this.dataIn2[xc][yc] >> 24 != 0) {
                    if (this.isBorder(xc, yc)) {
                        int y = -this.radius;
                        while (y <= this.radius) {
                            int x = -this.radius;
                            while (x <= this.radius) {
                                int yd;
                                int xd = this.getOffX(xc, x);
                                if (this.dataIn2[xd][yd = this.getOffY(yc, y)] >> 24 == 0) {
                                    int newWeight = max + 1 - (Math.abs(x) + Math.abs(y));
                                    this.weight[xd][yd] = Math.max(this.weight[xd][yd], newWeight);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        this.weight[xc][yc] = -2;
                    } else {
                        this.weight[xc][yc] = -1;
                    }
                }
                ++xc;
            }
            ++yc;
        }
        yc = 0;
        while (yc < this.height) {
            xc = 0;
            while (xc < this.width) {
                if (this.weight[xc][yc] == -1) {
                    this.dataOut[xc + this.width * yc] = this.filterRGB(this.color1, this.dataIn2[xc][yc]);
                } else if (this.weight[xc][yc] == -2) {
                    this.addGlowBorder(xc, yc, max);
                } else if (this.weight[xc][yc] > 0) {
                    this.addGlow(xc, yc, max);
                }
                ++xc;
            }
            ++yc;
        }
        this.consumer.setPixels(0, 0, this.width, this.height, MODEL, this.dataOut, 0, this.width);
        this.consumer.imageComplete(status);
    }

    protected void addGlow(int xc, int yc, int max) {
        float coef = (float)(this.weight[xc][yc] * this.alpha) / ((float)max * 255.0f);
        this.dataOut[xc + this.width * yc] = this.filterRGB(this.color2, -1, coef);
    }

    protected void addGlowBorder(int xc, int yc, int max) {
        float coef = (float)this.alpha / 255.0f;
        Color color3 = new Color(this.filterRGB(this.color1, this.color2, this.dataIn2[xc][yc], 0.625f), true);
        this.dataOut[xc + this.width * yc] = this.filterRGB(color3, -1, coef);
    }
}

