/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.image.filter;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public abstract class CommonFilter
extends ImageFilter {
    protected static final ColorModel MODEL = ColorModel.getRGBdefault();
    protected static final float BORDER_COEF = 0.625f;
    protected static final int MAX_ALPHA = -16777216;
    protected static final int MAX_RED = 0xFF0000;
    protected static final int MAX_GREEN = 65280;
    protected static final int MAX_BLUE = 255;
    protected static final int MAX_INT = -1;
    protected Color color1;
    protected Color color2;
    protected Color bgColor;
    protected int radius;
    protected int alpha;
    protected int width;
    protected int height;
    protected int[][] dataIn2;
    protected int[][] weight;
    protected int[] dataOut;
    protected int bgRGB;

    public CommonFilter(Color color1, Color color2, Color bgColor, int radius, int alpha) {
        this.color1 = color1;
        this.color2 = color2;
        this.bgColor = bgColor;
        this.radius = radius;
        this.alpha = alpha;
    }

    @Override
    public void setDimensions(int width, int height) {
        this.width = width + 2 * this.radius;
        this.height = height + 2 * this.radius;
        this.dataIn2 = new int[this.width][this.height];
        this.weight = new int[this.width][this.height];
        this.dataOut = new int[this.width * this.height];
        this.bgRGB = this.bgColor.getRGB();
        this.consumer.setDimensions(this.width, this.height);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int yc = 0;
        while (yc < h) {
            int xc = 0;
            while (xc < w) {
                int rgb;
                this.dataIn2[this.getOffX((int)xc, (int)(x + this.radius))][this.getOffY((int)yc, (int)(y + this.radius))] = rgb = model.getRGB(pixels[xc + w * yc]);
                ++xc;
            }
            ++yc;
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int yc = 0;
        while (yc < h) {
            int xc = 0;
            while (xc < w) {
                int rgb;
                this.dataIn2[this.getOffX((int)xc, (int)(x + this.radius))][this.getOffY((int)yc, (int)(y + this.radius))] = rgb = pixels[xc + w * yc];
                ++xc;
            }
            ++yc;
        }
    }

    protected int filterRGB(Color color, int rgb) {
        return this.filterRGB(color, rgb, this.alpha);
    }

    protected int filterRGB(Color color, int rgb, int alpha) {
        return this.filterRGB(color, rgb, (float)(rgb >> 24 & alpha) / 255.0f);
    }

    protected int filterRGB(Color color, int rgb, float coef) {
        return this.filterRGB(color, this.bgColor, rgb, coef);
    }

    protected int filterRGB(Color color1, Color color2, int rgb, float coef) {
        float anti = 1.0f - coef;
        int r = 0xFF0000 & rgb & (int)(coef * (float)color1.getRed() + anti * (float)color2.getRed()) << 16;
        int g = 0xFF00 & rgb & (int)(coef * (float)color1.getGreen() + anti * (float)color2.getGreen()) << 8;
        int b = 0xFF & rgb & (int)(coef * (float)color1.getBlue() + anti * (float)color2.getBlue());
        return 0xFF000000 | r | g | b;
    }

    protected int getOffX(int xc, int x) {
        return (xc + x + this.width) % this.width;
    }

    protected int getOffY(int yc, int y) {
        return (yc + y + this.height) % this.height;
    }

    protected boolean isBorder(int xc, int yc) {
        int y = -1;
        while (y <= 1) {
            int x = -1;
            while (x <= 1) {
                int yd;
                int xd = this.getOffX(xc, x);
                if (this.dataIn2[xd][yd = this.getOffY(yc, y)] >> 24 == 0) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    protected void makeInsivibleBackground() {
        int yc = 0;
        while (yc < this.height) {
            int xc = 0;
            while (xc < this.width) {
                if (this.dataOut[xc + this.width * yc] >> 24 == 0) {
                    this.dataOut[xc + this.width * yc] = this.bgRGB;
                }
                ++xc;
            }
            ++yc;
        }
    }
}

