/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.image;

import java.awt.image.BufferedImage;
import net.excessiveplus.common.image.TgaFile;
import net.excessiveplus.common.tools.Unsigned;

public class TgaImage
extends BufferedImage {
    private TgaFile tgaFile;

    public TgaImage(TgaFile tgaFile) {
        super(tgaFile.getHeader().getWidth(), tgaFile.getHeader().getHeight(), 2);
        this.tgaFile = tgaFile;
        this.loadData();
    }

    public TgaImage(byte[] bytes) {
        this(new TgaFile(bytes));
    }

    private void loadData() {
        short imageType = this.tgaFile.getHeader().getImageType();
        short pixelDepth = this.tgaFile.getHeader().getPixelDepth();
        switch (imageType) {
            case 2: {
                if (pixelDepth != 32) break;
                this.readBGR32();
                break;
            }
        }
    }

    private void readBGR32() {
        int width = this.tgaFile.getHeader().getWidth();
        int height = this.tgaFile.getHeader().getHeight();
        byte[] data = this.tgaFile.getData();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int offset = (x + width * y) * 4;
                short b = Unsigned.toUByte(data[offset]);
                short g = Unsigned.toUByte(data[offset + 1]);
                short r = Unsigned.toUByte(data[offset + 2]);
                short a = Unsigned.toUByte(data[offset + 3]);
                int argb = a << 24 | r << 16 | g << 8 | b;
                this.setRGB(x, height - y - 1, argb);
                ++y;
            }
            ++x;
        }
    }
}

