/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.image;

import java.io.ByteArrayInputStream;
import net.excessiveplus.common.image.TgaHeader;
import net.excessiveplus.common.tools.Unsigned;

public class TgaFile {
    private static final int BUFFER_SIZE = 2048;
    private TgaHeader header;
    private byte[] colorMap;
    private byte[] data;

    public TgaFile(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] headerBytes = new byte[18];
        bais.read(headerBytes, 0, 18);
        this.header = new TgaHeader(headerBytes);
        switch (this.header.getImageType()) {
            case 2: {
                int size = this.header.getWidth() * this.header.getHeight() * this.header.getPixelDepth() / 8;
                this.data = new byte[size];
                int off = 0;
                int count = 0;
                while (off < size && (count = bais.read(this.data, off, 2048)) != -1) {
                    off += count;
                }
                break;
            }
        }
    }

    public void printData() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.data.length) {
            str.append(Unsigned.toUByteHexaString(this.data[i]));
            if ((i + 1) % 4 == 0) {
                str.append(" ");
            }
            if ((i + 1) % (this.header.getWidth() * this.header.getPixelDepth()) == 0) {
                System.out.println(str);
                str = new StringBuffer();
            }
            ++i;
        }
    }

    public TgaHeader getHeader() {
        return this.header;
    }

    public void setHeader(TgaHeader header) {
        this.header = header;
    }

    public byte[] getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(byte[] colorMap) {
        this.colorMap = colorMap;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

