/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.excessiveplus.common.tools.Utils;

public class TextHelpMenuItem
extends JMenuItem {
    private static final String HELP_FILE_NOT_FOUND = "Help file not found";
    private String appName;
    private JDialog helpDialog;
    private String helpFileName;

    public TextHelpMenuItem(String appName, String helpFileName) {
        super("Text Help");
        this.appName = appName;
        this.helpFileName = helpFileName;
        this.helpPopup();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TextHelpMenuItem.this.helpDialog.setVisible(true);
            }
        });
    }

    public void helpPopup() {
        this.helpDialog = new JDialog((Frame)this.getTopLevelAncestor(), String.valueOf(this.appName) + " help", true);
        this.helpDialog.setResizable(false);
        File helpFile = new File(this.helpFileName);
        String charset = null;
        String text = "Help file not found (" + this.helpFileName + ") !";
        try {
            if (helpFile.exists() && (charset = Utils.checkFileEncoding(helpFile)) != null) {
                text = Utils.readFileEncoding(helpFile, charset);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JScrollPane scrollPane = new JScrollPane(20, 31);
        JTextArea textArea = new JTextArea(40, 60);
        textArea.setText(text);
        scrollPane.setViewportView(textArea);
        this.helpDialog.setContentPane(scrollPane);
        this.helpDialog.pack();
        Utils.center(this.helpDialog);
    }
}

