/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui.menu;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.excessiveplus.common.handlers.PreviewUpdater;
import net.excessiveplus.common.tools.Utils;

public class GifQualityMenuItem
extends JMenuItem {
    private static final int MIN_QUALITY_VALUE = 1;
    private static final int DEF_QUALITY_VALUE = 10;
    private static final int MAX_QUALITY_VALUE = 19;
    private PreviewUpdater previewUpdater;
    private JDialog qualityDialog;
    private JSlider qualitySlider;

    public GifQualityMenuItem(PreviewUpdater previewUpdater) {
        super("Gif quality ...");
        this.previewUpdater = previewUpdater;
        this.qualityPopup();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GifQualityMenuItem.this.qualityDialog.setVisible(true);
            }
        });
    }

    public void qualityPopup() {
        this.qualityDialog = new JDialog((Frame)this.getTopLevelAncestor(), "Gif Quality", true);
        this.qualityDialog.setResizable(false);
        Container contentPane = this.qualityDialog.getContentPane();
        this.qualitySlider = new JSlider(0, 1, 19, this.previewUpdater.getQuality());
        this.qualitySlider.setMajorTickSpacing(9);
        this.qualitySlider.setMinorTickSpacing(1);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setPaintLabels(true);
        this.qualitySlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(1, new JLabel("High"));
        ((Dictionary)labels).put(10, new JLabel("Normal"));
        ((Dictionary)labels).put(19, new JLabel("Fast"));
        this.qualitySlider.setLabelTable(labels);
        this.qualitySlider.setPreferredSize(new Dimension(400, 50));
        this.qualitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (!GifQualityMenuItem.this.qualitySlider.getValueIsAdjusting()) {
                    GifQualityMenuItem.this.previewUpdater.setQuality(GifQualityMenuItem.this.qualitySlider.getValue());
                }
            }
        });
        contentPane.add(this.qualitySlider);
        this.qualityDialog.pack();
        Utils.center(this.qualityDialog);
    }
}

