/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui.buttons;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.excessiveplus.common.handlers.CodeHandler;

public class ColorButton
extends JLabel {
    private static final Color HIGHLIGHT_COLOR = new Color(240, 240, 240);
    private static final Color SHADOW_COLOR = new Color(124, 124, 124);
    private static final Border RAISED_BORDER = BorderFactory.createBevelBorder(0, HIGHLIGHT_COLOR, SHADOW_COLOR);
    private static final Border LOWERED_BORDER = BorderFactory.createBevelBorder(1, HIGHLIGHT_COLOR, SHADOW_COLOR);
    private String code;

    public ColorButton(int type, Color color, String codeArg) {
        this.code = codeArg;
        this.setOpaque(true);
        this.setBackground(color);
        this.setCursor(new Cursor(12));
        this.setToolTipText("Adds color " + this.code);
        this.setBorder(RAISED_BORDER);
        switch (type) {
            case 1: {
                this.setPreferredSize(new Dimension(40, 24));
                break;
            }
            case 2: {
                this.setPreferredSize(new Dimension(20, 24));
            }
        }
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                ColorButton.this.setBorder(RAISED_BORDER);
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                ColorButton.this.setBorder(LOWERED_BORDER);
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ((CodeHandler)((Object)ColorButton.this.getTopLevelAncestor())).addCode(ColorButton.this.code);
            }
        });
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

