/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui.buttons;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.excessiveplus.common.handlers.CodeHandler;
import net.excessiveplus.common.tools.Hexa;

public class CharMapButton
extends JLabel {
    private static final Border RED_BORDER = BorderFactory.createLineBorder(Color.red);
    private String code;

    public CharMapButton(int x, int y) {
        int ascii = y * 16 + x;
        this.code = ascii >= 32 && ascii <= 126 ? Character.toString((char)ascii) : "#" + Hexa.toHexa(y) + Hexa.toHexa(x);
        this.setCursor(new Cursor(12));
        this.setToolTipText(this.code);
        this.setBounds(21 + x * 17, 21 + y * 17, 17, 17);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CharMapButton.this.setBorder(null);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CharMapButton.this.setBorder(RED_BORDER);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ((CodeHandler)((Object)CharMapButton.this.getTopLevelAncestor())).addCode(CharMapButton.this.code);
            }
        });
    }
}

