/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.excessiveplus.common.handlers.CodeHandler;
import net.excessiveplus.common.handlers.CountryHandler;

public class XPNamePanel
extends JPanel
implements CodeHandler,
CountryHandler {
    public static final int NAME_MAXLENGTH = 255;
    private JTextField xpName;
    private JComboBox xpCountry;
    private JLabel xpCountryLabel;
    private TreeMap<String, String> countryMapByCode;
    private TreeMap<String, String> countryMapByName;
    private Map<String, ImageIcon> countryImageMap;

    public XPNamePanel(TreeMap<String, String> countryMapByCodeArg, TreeMap<String, String> countryMapByNameArg, Map<String, ImageIcon> countryImageMapArg) {
        this.countryMapByCode = countryMapByCodeArg;
        this.countryMapByName = countryMapByNameArg;
        this.countryImageMap = countryImageMapArg;
        this.setLayout(null);
        this.setBorder(new TitledBorder("Code"));
        this.setSize(734, 82);
        JMenuItem copy = new JMenuItem("Copy");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPNamePanel.this.xpName.copy();
            }
        });
        JMenuItem cut = new JMenuItem("Cut");
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPNamePanel.this.xpName.cut();
            }
        });
        JMenuItem paste = new JMenuItem("Paste");
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPNamePanel.this.xpName.paste();
            }
        });
        JMenuItem selectAll = new JMenuItem("Select All");
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPNamePanel.this.xpName.selectAll();
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(copy);
        popup.add(cut);
        popup.add(paste);
        popup.add(new JSeparator());
        popup.add(selectAll);
        this.xpName = new JTextField(10);
        this.xpName.setBounds(13, 19, 708, 20);
        this.xpName.setComponentPopupMenu(popup);
        this.xpName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = XPNamePanel.this.xpName.getText();
                if (text.length() > 255) {
                    XPNamePanel.this.xpName.setText(text.substring(0, 255));
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.xpCountry = new JComboBox();
        this.xpCountry.setBounds(55, 49, 666, 20);
        for (String countryName : this.countryMapByName.keySet()) {
            this.xpCountry.addItem(countryName);
        }
        this.xpCountry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon tmpImageIcon = (ImageIcon)XPNamePanel.this.countryImageMap.get(XPNamePanel.this.getCountryCode());
                if (tmpImageIcon == null) {
                    tmpImageIcon = (ImageIcon)XPNamePanel.this.countryImageMap.get("XX");
                }
                XPNamePanel.this.xpCountryLabel.setIcon(tmpImageIcon);
            }
        });
        this.xpCountryLabel = new JLabel();
        this.xpCountryLabel.setBounds(13, 43, 32, 32);
        this.xpCountryLabel.setOpaque(true);
        this.setCountryCode("XX");
        this.add(this.xpCountryLabel);
        this.add(this.xpCountry);
        this.add(this.xpName);
    }

    @Override
    public void addCode(String code) {
        int startPos;
        String textCode = this.xpName.getText();
        if (this.xpName.getSelectedText() == null) {
            startPos = this.xpName.getCaretPosition();
            textCode = String.valueOf(textCode.substring(0, startPos)) + code + textCode.substring(startPos);
        } else {
            startPos = this.xpName.getSelectionStart();
            textCode = String.valueOf(textCode.substring(0, startPos)) + code + textCode.substring(this.xpName.getSelectionEnd());
        }
        this.xpName.setText(textCode);
        this.xpName.setCaretPosition(startPos + code.length());
        this.xpName.requestFocus();
    }

    @Override
    public void clearCode() {
        this.xpName.setText("");
        this.xpName.requestFocus();
    }

    @Override
    public String getCode() {
        return this.xpName.getText();
    }

    @Override
    public String getCountryCode() {
        return this.countryMapByName.get((String)this.xpCountry.getSelectedItem());
    }

    @Override
    public void setCountryCode(String countryCode) {
        if (countryCode != null) {
            this.xpCountry.setSelectedItem(this.countryMapByCode.get(countryCode));
        }
    }
}

