/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.excessiveplus.common.bind.Bind;
import net.excessiveplus.common.gui.SoundPanel;
import net.excessiveplus.common.handlers.CodeHandler;

public class XPBindPanel
extends JPanel
implements CodeHandler {
    public static final int NAME_MAXLENGTH = 255;
    private JTextField bindText;
    private JComboBox soundBindsCat;
    private JComboBox soundBinds;
    private JComboBox bindKeys;
    private SoundPanel soundPanel;
    private TreeSet<String> soundBindsCatList;
    private TreeMap<String, byte[]> soundBindsMap;
    private ActionListener soundBindsActionListener;

    public XPBindPanel(TreeMap<String, byte[]> soundBindsMapArg) {
        this.soundBindsMap = soundBindsMapArg;
        this.soundBindsCatList = new TreeSet();
        this.soundBindsCatList.add(" ");
        this.soundBindsCatList.add("-");
        if (this.soundBindsMap != null && this.soundBindsMap.size() >= 1) {
            for (String key : this.soundBindsMap.keySet()) {
                int index = key.indexOf("_");
                if (index == -1) continue;
                String cat = key.substring(0, index);
                this.soundBindsCatList.add(cat);
            }
        }
        this.setLayout(null);
        this.setBorder(new TitledBorder("Sound Bind"));
        this.setSize(734, 82);
        JMenuItem copy = new JMenuItem("Copy");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPBindPanel.this.bindText.copy();
            }
        });
        JMenuItem cut = new JMenuItem("Cut");
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPBindPanel.this.bindText.cut();
            }
        });
        JMenuItem paste = new JMenuItem("Paste");
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPBindPanel.this.bindText.paste();
            }
        });
        JMenuItem selectAll = new JMenuItem("Select All");
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPBindPanel.this.bindText.selectAll();
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(copy);
        popup.add(cut);
        popup.add(paste);
        popup.add(new JSeparator());
        popup.add(selectAll);
        this.bindText = new JTextField(10);
        this.bindText.setBounds(378, 19, 343, 20);
        this.bindText.setComponentPopupMenu(popup);
        this.bindText.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = XPBindPanel.this.bindText.getText();
                if (text.length() > 255) {
                    XPBindPanel.this.bindText.setText(text.substring(0, 255));
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.bindKeys = new JComboBox();
        for (String bindKey : Bind.getKeysList()) {
            this.bindKeys.addItem(bindKey);
        }
        this.bindKeys.setBounds(273, 19, 100, 20);
        this.soundPanel = new SoundPanel(new Runnable(){

            @Override
            public void run() {
                XPBindPanel.this.soundBindsCat.setEnabled(false);
                XPBindPanel.this.soundBinds.setEnabled(false);
            }
        }, new Runnable(){

            @Override
            public void run() {
                XPBindPanel.this.soundBindsCat.setEnabled(true);
                XPBindPanel.this.soundBinds.setEnabled(true);
            }
        });
        this.soundPanel.setBounds(223, 19, 45, 20);
        this.soundBinds = new JComboBox();
        this.soundBinds.setBounds(68, 19, 150, 20);
        this.soundBinds.addItem(" ");
        this.soundBindsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String soundBind;
                String soundBindCat = XPBindPanel.this.getSoundBindCat();
                if (!soundBindCat.equals(" ") && !(soundBind = XPBindPanel.this.getSoundBind()).equals(" ")) {
                    if (soundBindCat != "-") {
                        XPBindPanel.this.soundPanel.setSoundData((byte[])XPBindPanel.this.soundBindsMap.get(String.valueOf(soundBindCat) + "_" + soundBind));
                    } else {
                        XPBindPanel.this.soundPanel.setSoundData((byte[])XPBindPanel.this.soundBindsMap.get(soundBind));
                    }
                    soundBind = soundBind.substring(0, soundBind.length() - 4);
                    soundBind = soundBind.replaceAll("_", " ");
                    XPBindPanel.this.bindText.setText(soundBind);
                }
            }
        };
        this.soundBindsCat = new JComboBox();
        for (String cat : this.soundBindsCatList) {
            this.soundBindsCat.addItem(cat);
        }
        this.soundBindsCat.setBounds(13, 19, 50, 20);
        this.soundBindsCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String soundBindCat = XPBindPanel.this.getSoundBindCat();
                XPBindPanel.this.soundBinds.removeActionListener(XPBindPanel.this.soundBindsActionListener);
                XPBindPanel.this.soundBinds.removeAllItems();
                XPBindPanel.this.soundBinds.addItem(" ");
                if (!soundBindCat.equals(" ")) {
                    for (String bind : XPBindPanel.this.soundBindsMap.keySet()) {
                        if (bind == null) continue;
                        if (soundBindCat.equals("-")) {
                            if (bind.contains("_")) continue;
                            XPBindPanel.this.soundBinds.addItem(bind);
                            continue;
                        }
                        if (!bind.startsWith(String.valueOf(soundBindCat) + "_")) continue;
                        XPBindPanel.this.soundBinds.addItem(bind.substring(soundBindCat.length() + 1));
                    }
                }
                XPBindPanel.this.soundBinds.addActionListener(XPBindPanel.this.soundBindsActionListener);
            }
        });
        this.add(this.soundBindsCat);
        this.add(this.soundBinds);
        this.add(this.soundPanel);
        this.add(this.bindKeys);
        this.add(this.bindText);
    }

    @Override
    public void addCode(String code) {
        int startPos;
        String textCode = this.bindText.getText();
        if (this.bindText.getSelectedText() == null) {
            startPos = this.bindText.getCaretPosition();
            textCode = String.valueOf(textCode.substring(0, startPos)) + code + textCode.substring(startPos);
        } else {
            startPos = this.bindText.getSelectionStart();
            textCode = String.valueOf(textCode.substring(0, startPos)) + code + textCode.substring(this.bindText.getSelectionEnd());
        }
        this.bindText.setText(textCode);
        this.bindText.setCaretPosition(startPos + code.length());
        this.bindText.requestFocus();
    }

    @Override
    public void clearCode() {
        this.bindText.setText("");
        this.bindText.requestFocus();
    }

    @Override
    public String getCode() {
        return this.bindText.getText();
    }

    public String getSoundBindCat() {
        return (String)this.soundBindsCat.getSelectedItem();
    }

    public void setSoundBindCat(String bind) {
        if (bind != null) {
            this.soundBindsCat.setSelectedItem(bind);
        }
    }

    public String getSoundBind() {
        return (String)this.soundBinds.getSelectedItem();
    }

    public void setSoundBind(String bind) {
        if (bind != null) {
            this.soundBinds.setSelectedItem(bind);
        }
    }
}

