/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui;

import javax.swing.JButton;
import net.excessiveplus.common.gui.buttons.SoundButton;
import net.excessiveplus.common.sound.WaveBytesReader;

public class SoundPanel
extends JButton {
    private WaveBytesReader waveReader;
    private SoundButton startButton;
    private SoundButton stopButton;
    private Runnable startAction;
    private Runnable stopAction;

    public SoundPanel(Runnable startAction, Runnable stopAction) {
        this.startAction = startAction;
        this.stopAction = stopAction;
        this.setLayout(null);
        this.setSize(45, 20);
        this.setBorder(null);
        this.startButton = new SoundButton(this, true);
        this.startButton.setBounds(25, 0, 20, 20);
        this.startButton.setEnabled(false);
        this.stopButton = new SoundButton(this, false);
        this.stopButton.setBounds(0, 0, 20, 20);
        this.stopButton.setEnabled(false);
        this.add(this.stopButton);
        this.add(this.startButton);
    }

    public void setSoundData(byte[] soundData) {
        if (this.startButton.getIconState() == 0) {
            this.setWaveReader(new WaveBytesReader(soundData, new Runnable(){

                @Override
                public void run() {
                    SoundPanel.this.setPlaying(false);
                }
            }));
            this.startButton.setEnabled(true);
        }
    }

    public void setPlaying(boolean playing) {
        if (playing) {
            this.stopButton.setEnabled(true);
            if (this.startAction != null) {
                this.startAction.run();
            }
        } else {
            this.stopButton.setEnabled(false);
            this.startButton.setEnabled(true);
            this.startButton.switchIcon(0);
            if (this.stopAction != null) {
                this.stopAction.run();
            }
        }
    }

    public void setWaveReader(WaveBytesReader waveReader) {
        this.waveReader = waveReader;
    }

    public WaveBytesReader getWaveReader() {
        return this.waveReader;
    }
}

