/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.excessiveplus.common.gui.buttons.ColorButton;
import net.excessiveplus.common.tools.Qname;

public class CharColorChooser
extends JColorChooser {
    private JPanel customColorButtonPanel;
    private ColorButton customColorButton;

    public CharColorChooser() {
        this.setLayout(null);
        this.setSize(430, 300);
        this.customColorButton = new ColorButton(1, Color.gray, "^x808080");
        JLabel spacer = new JLabel();
        spacer.setPreferredSize(new Dimension(20, 25));
        this.customColorButtonPanel = new JPanel();
        this.customColorButtonPanel.setBounds(77, 9, 276, 34);
        Color[] stdColors = Qname.STD_COLORS;
        int i = 0;
        while (i < stdColors.length) {
            this.customColorButtonPanel.add(new ColorButton(2, stdColors[i], "^" + i));
            ++i;
        }
        this.customColorButtonPanel.add(spacer);
        this.customColorButtonPanel.add(this.customColorButton);
        this.getComponent(0).setBounds(0, 0, 430, 254);
        JPanel previewPanelHolder = (JPanel)this.getComponent(1);
        ((TitledBorder)previewPanelHolder.getBorder()).setTitle("Colors");
        previewPanelHolder.setLayout(null);
        previewPanelHolder.setBounds(0, 253, 430, 46);
        previewPanelHolder.remove(0);
        previewPanelHolder.add(this.customColorButtonPanel);
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Color color = CharColorChooser.this.getColor();
                CharColorChooser.this.customColorButton.setBackground(color);
                CharColorChooser.this.customColorButton.setCode(Qname.toCustomColor(color));
                CharColorChooser.this.customColorButton.setToolTipText("Adds color " + CharColorChooser.this.customColorButton.getCode());
            }
        });
    }

    public Color getCustomColor() {
        return this.customColorButton.getBackground();
    }
}

