/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.common.bind;

import java.util.TreeSet;
import net.excessiveplus.common.bind.CommandBind;
import net.excessiveplus.common.bind.SoundBind;

public abstract class Bind {
    public static int TYPE_COMMAND = 0;
    public static int TYPE_SAY = 1;
    public static int TYPE_SOUND = 2;
    private static TreeSet<String> keysList = new TreeSet();
    private int type;

    static {
        keysList.add(" ");
        char c = 'a';
        while (c <= 'z') {
            keysList.add("" + c);
            c = (char)(c + '\u0001');
        }
        int i = 0;
        while (i <= 9) {
            keysList.add("" + i);
            ++i;
        }
        i = 0;
        while (i <= 12) {
            keysList.add("f" + i);
            ++i;
        }
        keysList.add("'");
        keysList.add("-");
        keysList.add("/");
        keysList.add("semicolon");
        keysList.add("=");
        keysList.add("[");
        keysList.add("\\");
        keysList.add("]");
        keysList.add(",");
        keysList.add(".");
        keysList.add("alt");
        keysList.add("ctrl");
        keysList.add("shift");
        keysList.add("enter");
        keysList.add("ins");
        keysList.add("del");
        keysList.add("home");
        keysList.add("end");
        keysList.add("pgup");
        keysList.add("pgdn");
        keysList.add("uparrow");
        keysList.add("downarrow");
        keysList.add("leftarrow");
        keysList.add("rightarrow");
        keysList.add("kp_ins");
        keysList.add("kp_end");
        keysList.add("kp_downarrow");
        keysList.add("kp_pgdn");
        keysList.add("kp_leftarrow");
        keysList.add("kp_5");
        keysList.add("kp_rightarrow");
        keysList.add("kp_home");
        keysList.add("kp_uparrow");
        keysList.add("kp_pgup");
        keysList.add("kp_del");
        keysList.add("kp_enter");
        keysList.add("kp_plus");
        keysList.add("kp_minus");
        keysList.add("*");
        keysList.add("kp_slash");
        keysList.add("mouse1");
        keysList.add("mouse2");
        keysList.add("mouse3");
        keysList.add("mwheelup");
        keysList.add("mwheeldown");
    }

    public Bind(int type, String key, String text) {
        this.type = type;
    }

    public static Bind validate(String bind) {
        String[] bindSplit = bind.split("\\p{Blank}");
        String key = null;
        String text = null;
        int i = 1;
        while (i < bindSplit.length) {
            if (!bindSplit[i].isEmpty()) {
                if (key == null) {
                    key = bindSplit[i];
                } else {
                    text = bindSplit[i].substring(1, bindSplit[i].length() - 1);
                }
            }
            ++i;
        }
        System.out.println("Bind.validate() : [" + key + "],[" + text + "]");
        if (Bind.isValidKey(key)) {
            if (text.startsWith("say")) {
                return new SoundBind(key, text);
            }
            return new CommandBind(key, text);
        }
        return null;
    }

    public static boolean isValidKey(String key) {
        return keysList.contains(key);
    }

    public static TreeSet<String> getKeysList() {
        return keysList;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }
}

