/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.xpqname.menu;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import net.excessiveplus.common.Links;
import net.excessiveplus.common.tools.Utils;

public class AboutMenuItem
extends JMenuItem
implements Links {
    private static final Color HIGHLIGHT_COLOR = new Color(240, 240, 240);
    private static final Color SHADOW_COLOR = new Color(124, 124, 124);
    private static final Border RAISED_BORDER = BorderFactory.createBevelBorder(0, HIGHLIGHT_COLOR, SHADOW_COLOR);
    private static final Border LOWERED_BORDER = BorderFactory.createBevelBorder(1, HIGHLIGHT_COLOR, SHADOW_COLOR);
    private String appName;
    private String appVersion;
    private JDialog aboutDialog;

    public AboutMenuItem(String appName, String appVersion) {
        super("About " + appName);
        this.appName = appName;
        this.appVersion = appVersion;
        this.aboutPopup();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AboutMenuItem.this.aboutDialog.setVisible(true);
            }
        });
    }

    public void aboutPopup() {
        Font boldFont = this.getFont().deriveFont(1, 16.0f);
        this.aboutDialog = new JDialog((Frame)this.getTopLevelAncestor(), "About " + this.appName, true);
        this.aboutDialog.setResizable(false);
        Container contentPane = this.aboutDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel1 = new JPanel();
        JLabel titleLabel = new JLabel(String.valueOf(this.appName) + " " + this.appVersion);
        titleLabel.setFont(boldFont);
        panel1.add(titleLabel);
        contentPane.add(panel1);
        contentPane.add(new JSeparator());
        JPanel panel2 = new JPanel();
        String text = "Made for Excessive Plus 2.0 version and higher.  \nLicensed as FreeWare.\n\nCopyright \u00a9 2010 Aliminium. All Rights Reserved.  ";
        JTextArea textArea = new JTextArea(text);
        textArea.setOpaque(false);
        panel2.add(textArea);
        panel2.add(new JSeparator(1));
        byte[] bytes = Utils.loadRessourceBytes("/img/eplus.jpg");
        JLabel eplus = new JLabel(new ImageIcon(bytes));
        eplus.setCursor(new Cursor(12));
        eplus.setBorder(RAISED_BORDER);
        eplus.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                ((JLabel)arg0.getComponent()).setBorder(RAISED_BORDER);
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                ((JLabel)arg0.getComponent()).setBorder(LOWERED_BORDER);
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Utils.visitURI("http://www.excessiveplus.net");
            }
        });
        panel2.add(eplus);
        contentPane.add(panel2);
        JPanel panel3 = new JPanel();
        bytes = Utils.loadRessourceBytes("/img/ali.gif");
        JLabel ali = new JLabel(new ImageIcon(bytes), 0);
        panel3.add(ali);
        contentPane.add(panel3);
        contentPane.add(new JSeparator());
        JPanel panel4 = new JPanel();
        text = "Special thanks to :\n + E+ team for the game.\n + Beast for infos given.\n + Epsilon for testing, analysing and debuging.\n + Killer for providing the help.\n + All testers.\n + Community for patience.";
        textArea = new JTextArea(text);
        textArea.setOpaque(false);
        panel4.add(textArea);
        JPanel panel5 = new JPanel();
        panel5.setPreferredSize(new Dimension(200, 120));
        bytes = Utils.loadRessourceBytes("/img/beast.gif");
        JLabel beast = new JLabel(new ImageIcon(bytes));
        panel5.add(beast);
        bytes = Utils.loadRessourceBytes("/img/epsilone.gif");
        JLabel epsilone = new JLabel(new ImageIcon(bytes));
        panel5.add(epsilone);
        bytes = Utils.loadRessourceBytes("/img/killer.gif");
        JLabel killer = new JLabel(new ImageIcon(bytes));
        panel5.add(killer);
        panel4.add(panel5);
        contentPane.add(panel4);
        this.aboutDialog.pack();
        Utils.center(this.aboutDialog);
    }
}

