/*
 * Decompiled with CFR 0.152.
 */
package net.excessiveplus.xpqname;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.excessiveplus.common.gui.InterfacePanel;
import net.excessiveplus.common.gui.PreviewPanel;
import net.excessiveplus.common.gui.XPNamePanel;
import net.excessiveplus.common.handlers.AppHandler;
import net.excessiveplus.common.handlers.CfgHandler;
import net.excessiveplus.common.handlers.CodeHandler;
import net.excessiveplus.common.handlers.GifHandler;
import net.excessiveplus.common.handlers.PreviewUpdater;
import net.excessiveplus.common.tools.AnimatedGifGenerator;
import net.excessiveplus.common.tools.Qname;
import net.excessiveplus.common.tools.Utils;
import net.excessiveplus.xpqname.menu.XPQnameMenuBar;

public class XPQname
extends JFrame
implements AppHandler,
PreviewUpdater,
CodeHandler,
GifHandler,
CfgHandler {
    public static final String APP_NAME = "XP Qname";
    public static final String APP_VERSION = "1.1";
    public static final String COUNTRIES_FILE_NAME = "ipdb.db";
    public static final Color PREVIEW_COLOR = new Color(40, 40, 40);
    private JPanel jContentPane;
    private JMenuBar xpQnameMenuBar;
    private InterfacePanel interfacePanel;
    private PreviewPanel previewPanel;
    private XPNamePanel xpNamePanel;
    private TreeMap<String, String> countryMapByCode;
    private TreeMap<String, String> countryMapByName;
    private Map<String, ImageIcon> countryImageMap;
    private File ePlusFolder;
    private File currentFolder;
    private File cfgFile;
    private String cfgFileContent = "";
    private String code;
    private BufferedImage[] charMap;
    private BufferedImage[][] xpFont;
    private AnimatedGifGenerator gifGen;

    public XPQname(String ePlusFolderPath) {
        File countriesPropFile;
        this.currentFolder = this.ePlusFolder = new File(ePlusFolderPath);
        File[] pk3Files = this.ePlusFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("z-xp-") && name.endsWith(".pk3");
            }
        });
        if (pk3Files == null || pk3Files.length == 0) {
            try {
                String msg = "Invalid e+ folder";
                JOptionPane.showMessageDialog(this, this.ePlusFolder.getCanonicalPath(), "XP Qname: " + msg, 0);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        if (!(countriesPropFile = new File(String.valueOf(this.ePlusFolder.getAbsolutePath()) + File.separator + COUNTRIES_FILE_NAME)).exists()) {
            String msg = "File not found";
            JOptionPane.showMessageDialog(this, String.valueOf(msg) + " :\n" + this.ePlusFolder.getAbsolutePath() + File.separator + COUNTRIES_FILE_NAME, "XP Qname: " + msg, 0);
            System.exit(1);
        }
        this.countryMapByCode = new TreeMap();
        this.countryMapByName = new TreeMap();
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + this.ePlusFolder.getAbsolutePath() + File.separator + COUNTRIES_FILE_NAME);
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from countries;");
            while (rs.next()) {
                this.countryMapByCode.put(rs.getString("country_code"), rs.getString("country_name"));
                this.countryMapByName.put(rs.getString("country_name"), rs.getString("country_code"));
            }
            rs.close();
            conn.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.charMap = new BufferedImage[2];
        this.charMap[0] = Utils.loadRessourceImage("/img/charmap0.png");
        this.charMap[1] = Utils.loadRessourceImage("/img/charmap1.png");
        this.countryImageMap = new TreeMap<String, ImageIcon>();
        if (pk3Files.length >= 1) {
            int i = pk3Files.length - 1;
            while (i >= 0) {
                File pk3File = pk3Files[i];
                try {
                    ZipFile zipFile = new ZipFile(pk3File);
                    Qname.readFlags(zipFile, this.countryImageMap);
                    if (this.xpFont == null) {
                        this.xpFont = Qname.readFonts(zipFile);
                    }
                }
                catch (ZipException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                --i;
            }
            if (this.xpFont == null) {
                String msg = "Fonts not found ";
                JOptionPane.showMessageDialog(this, "Can't find fonts in pk3s.\nIncompatible E+ version !", "XP Qname: " + msg, 0);
                System.exit(1);
            }
        }
        this.gifGen = new AnimatedGifGenerator(this, this.xpFont, 1, PREVIEW_COLOR);
        this.initialize();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (XPQname.this.code == null || !XPQname.this.code.equals(XPQname.this.getCode())) {
                    XPQname.this.updatePreview();
                }
                XPQname.this.code = XPQname.this.getCode();
            }
        };
        Timer timer = new Timer();
        timer.schedule(task, 1000L, 2000L);
    }

    private void initialize() {
        this.setResizable(false);
        this.setJMenuBar(this.getQnameMenuBar());
        this.setBounds(new Rectangle(0, 0, 740, 600));
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getJContentPane());
        this.setTitle(APP_NAME);
        this.setIconImage(Utils.loadRessourceImage("/img/qname.png"));
        Utils.center(this);
    }

    private JMenuBar getQnameMenuBar() {
        if (this.xpQnameMenuBar == null) {
            this.xpQnameMenuBar = new XPQnameMenuBar(this);
        }
        return this.xpQnameMenuBar;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.interfacePanel = new InterfacePanel(this.charMap);
            this.interfacePanel.setLocation(0, 0);
            this.jContentPane.add(this.interfacePanel);
            this.previewPanel = new PreviewPanel(PREVIEW_COLOR);
            this.previewPanel.setLocation(0, 380);
            this.jContentPane.add(this.previewPanel);
            this.xpNamePanel = new XPNamePanel(this.countryMapByCode, this.countryMapByName, this.countryImageMap);
            this.xpNamePanel.setLocation(0, 460);
            this.jContentPane.add(this.xpNamePanel);
        }
        return this.jContentPane;
    }

    public static void main(String[] args) {
        String ePlusFolderPath = "..";
        if (args.length >= 1) {
            ePlusFolderPath = args[0];
        }
        System.setProperty("file.encoding", "UTF-8");
        Locale.setDefault(Locale.ENGLISH);
        XPQname xpQname = new XPQname(ePlusFolderPath);
        xpQname.setVisible(true);
    }

    @Override
    public void updatePreview() {
        this.previewPanel.updatePreview(AnimatedGifGenerator.refreshingCodeBytes);
        byte[] gifBytes = this.gifGen.generateGif(this.getCode());
        if (gifBytes != null) {
            this.previewPanel.updatePreview(gifBytes);
        } else {
            this.previewPanel.updatePreview(null);
        }
        this.interfacePanel.switchCharMap(this.gifGen.getThin());
    }

    @Override
    public synchronized void setPreviewMode(int previewMode) {
        this.gifGen.setPreviewMode(previewMode);
        this.updatePreview();
    }

    @Override
    public int getQuality() {
        return this.gifGen.getQuality();
    }

    @Override
    public synchronized void setQuality(int quality) {
        this.gifGen.setQuality(quality);
        this.updatePreview();
    }

    @Override
    public void addCode(String code) {
        this.xpNamePanel.addCode(code);
    }

    @Override
    public void clearCode() {
        this.xpNamePanel.clearCode();
    }

    @Override
    public String getCode() {
        return this.xpNamePanel.getCode();
    }

    @Override
    public File selectGifFile() {
        JFileChooser gifChooser = new JFileChooser(this.currentFolder);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Gif files", "gif");
        gifChooser.setFileFilter(filter);
        int ret = gifChooser.showSaveDialog(this);
        if (ret == 0) {
            this.currentFolder = gifChooser.getSelectedFile().getParentFile();
            File file = null;
            try {
                file = gifChooser.getSelectedFile();
                if (!file.getName().endsWith(".gif")) {
                    file = new File(file.getCanonicalFile() + ".gif");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        return null;
    }

    @Override
    public void saveGif(File file) {
        int previewMode = this.gifGen.getPreviewMode();
        Color bgColor = this.interfacePanel.getCustomColor();
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else if (!this.confirmOverwrite(file)) {
                return;
            }
            AnimatedGifGenerator localGifGen = new AnimatedGifGenerator(this, this.xpFont, previewMode, bgColor);
            if (localGifGen.saveGif(this.getCode(), file)) {
                JOptionPane.showMessageDialog(this, String.valueOf(file.getName()) + " saved.");
            } else {
                JOptionPane.showMessageDialog(this, "Invalide code.", "XP Qname : Warning", 2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error while saving file : " + file.getName(), "XP Qname : Error", 0);
        }
    }

    @Override
    public File selectCfgFile(boolean toSave) {
        JFileChooser cfgChooser = new JFileChooser(this.currentFolder);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Config files", "cfg");
        cfgChooser.setFileFilter(filter);
        int ret = toSave ? cfgChooser.showSaveDialog(this) : cfgChooser.showOpenDialog(this);
        if (ret == 0) {
            this.currentFolder = cfgChooser.getSelectedFile().getParentFile();
            File file = null;
            try {
                file = cfgChooser.getSelectedFile();
                if (!file.getName().endsWith(".cfg")) {
                    file = new File(file.getCanonicalFile() + ".cfg");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        return null;
    }

    @Override
    public void saveCfg(File file) {
        OutputStreamWriter fw = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else if (!this.confirmOverwrite(file)) {
                return;
            }
            try {
                fw = new FileWriter(file);
                fw.write("// Generated by XP Qname 1.1" + Utils.LINE_SEP);
                fw.write("// ---------------------------" + Utils.LINE_SEP);
                fw.write(this.cfgFileContent);
                fw.write("// ---------------------------" + Utils.LINE_SEP);
                fw.write("seta xp_country \"" + this.xpNamePanel.getCountryCode() + "\"" + Utils.LINE_SEP);
                fw.write("seta xp_name \"" + this.getCode() + "\"" + Utils.LINE_SEP);
                fw.flush();
                this.setCfgFile(file);
                JOptionPane.showMessageDialog(this, String.valueOf(file.getName()) + " saved.");
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error while saving file : " + file.getName(), "XP Qname : Error", 0);
            }
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void readCfg(File file) {
        String charset = null;
        this.clearCode();
        this.xpNamePanel.setCountryCode("XX");
        try {
            String[] lines;
            charset = Utils.checkFileEncoding(file);
            if (charset == null) {
                JOptionPane.showMessageDialog(this, "Unrecognised file encoding : " + file.getName(), "XP Qname : Error", 0);
                return;
            }
            String text = Utils.readFileEncoding(file, charset);
            if (text == null) {
                JOptionPane.showMessageDialog(this, "Unknown error while reading file  : " + file.getName(), "XP Qname : Error", 0);
                return;
            }
            this.cfgFileContent = "";
            String[] stringArray = lines = text.split(Utils.LINE_SEP);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim()).startsWith("// Generated by ") && !line.startsWith("// ----")) {
                    String tmp = Utils.readCvar("name", line);
                    if (tmp != null) {
                        this.clearCode();
                        this.addCode(Qname.transformFromNameToXPName(tmp));
                    } else {
                        tmp = Utils.readCvar("xp_name", line);
                        if (tmp != null) {
                            this.clearCode();
                            this.addCode(tmp);
                        } else {
                            tmp = Utils.readCvar("xp_country", line);
                            if (tmp != null) {
                                this.xpNamePanel.setCountryCode(tmp);
                            } else {
                                this.cfgFileContent = String.valueOf(this.cfgFileContent) + line + Utils.LINE_SEP;
                            }
                        }
                    }
                }
                ++n2;
            }
            this.setCfgFile(file);
            JOptionPane.showMessageDialog(this, String.valueOf(file.getName()) + " opened.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error while reading file : " + file.getName(), "XP Qname : Error", 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error while reading file : " + file.getName(), "XP Qname : Error", 0);
        }
    }

    @Override
    public File getCfgFile() {
        return this.cfgFile;
    }

    @Override
    public void setCfgFile(File cfgFile) {
        this.cfgFile = cfgFile;
        try {
            if (cfgFile == null) {
                this.setTitle(APP_NAME);
            } else {
                this.setTitle("XP Qname - " + cfgFile.getCanonicalFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean confirmOverwrite(File file) {
        return this.confirmMessage("overwrite " + file.getName());
    }

    @Override
    public boolean confirmClose(File file) {
        return this.confirmMessage("close " + file.getName());
    }

    public boolean confirmMessage(String action) {
        String message = "Are you sure you want to " + action + " ?";
        int answer = JOptionPane.showConfirmDialog(this, message, null, 0);
        return answer == 0;
    }

    @Override
    public File getEplusFolder() {
        return this.ePlusFolder;
    }

    @Override
    public File getCurrentFolder() {
        return this.currentFolder;
    }
}

